/*******************************************************
Filename		:  FA_BIO_RESULT_data1.sql
Release 		:  c2.0, C2.0.1
SIR			:  1495,1558
Description		:  Migrate data from the TSRRSULT, TSRFDACT, TSRBRG, and TSRBRGI tables to
			   the FA_BIOLOGICAL_RESULT fact table.
Author			:  Christine Tsang
Date			:	7/07/2003 
                   		8/01/2003 - Updated date field logic. -C Tsang 
                   		8/25/2003 - Updated date field logic. -C Tsang 
                   		8/27/2003 - SIR 1495 TIR#6- Added species_number. 
				10/08/2003 - Populate Result BLOB_TITLE -JW
				10/29/2003 - Populate activity BLOB_TITLE -wn
				01/16/2004 - SIR 1586 Moved connect string to master install script -JW
				07/26/2004 - added organization_is_number -JW
				08/28/2044 - change tsruom_is_number to FK_UNIT_CONVERSION -JW
Comments		:  Run this script after fa_bio_result_table.sql and before create_temp_tables.sql
**********************************************************/
set echo off;
spool FA_BIOLOGICAL_RESULT_data1.log
set serveroutput on

-- create sequence for pk_isn

drop sequence seq_FA_BIOLOGICAL_RESULT;

create sequence seq_FA_BIOLOGICAL_RESULT
start with 1 increment by 1 nomaxvalue nocycle cache 100;

DECLARE

cursor orgs is
	select organization_id, organization_is_number
	from di_org
	order by organization_id;

BEGIN

FOR v_org in orgs loop

-- General biological results (tissue/individual)
INSERT INTO FA_BIOLOGICAL_RESULT (pk_isn,
      SPECIES_NUMBER,
	RESULT_VALUE,
	RESULT_VALUE_TEXT,
	SAMPLE_FRACTION_TYPE,
	RESULT_VALUE_TYPE,
	STATISTIC_TYPE,
	RESULT_VALUE_STATUS,
	WEIGHT_BASIS_TYPE,
	TEMPERATURE_BASIS_LEVEL,
	DURATION_BASIS,
	LAB_CERTIFIED,
	LAB_BATCH_ID,
	ANALYSIS_DATE_TIME,
	--ANALYSIS_TIME,
	ANALYSIS_TIME_ZONE,
	DISTANCE_MEASURE_FROM,
	DISTANCE_MEASURE_TO,
	REPLICATE_ANALYSIS_COUNT,
	PRECISION,
	CONFIDENCE_LEVEL,
	DILUTION_INDICATOR,
	RECOVERY_INDICATOR,
	CORRECTION_INDICATOR,
	RESULT_IS_NUMBER,
	ORGANIZATION_ID,
	ORGANIZATION_IS_NUMBER,
	ACTIVITY_IS_NUMBER,
	FK_CHAR,
	TSRCHAR_ORG_ID,
	FK_UNIT_CONVERSION,
	TSRUOM_ORG_ID,
	TSRANLPR_IS_NUMBER,
	TSRANLPR_ORG_ID,
	TSRLSPP_IS_NUMBER,
	TSRLSPP_ORG_ID,
	TSRLAB_IS_NUMBER,
	BIAS,
	CONF_LVL_CORR_BIAS, 
      FEEDING_GROUP,
      POLLUTION_TOLERANCE,
      TROPHIC_LEVEL,
      HABIT,
      VOLTINISM,
      TSMPRMVL_IS_NUMBER,
	BLOB_TITLE,
--activity elements
	ACTIVITY_START_DATE_TIME,
	--ACTIVITY_START_TIME,
	ACT_START_TIME_ZONE,
	TSRSTVST_IS_NUMBER,
 	ACTIVITY_ID,            
 	REPLICATE_NUMBER,       
	ACTIVITY_MEDIUM,
 	ACTIVITY_TYPE,          
 	ACTIVITY_CATEGORY,      
 	ACTIVITY_INTENT,        
      ACTIVITY_SUBJECT_TAXON,
      BIOPART_NAME,
	ACTIVITY_STOP_DATE_TIME,     
	--ACTIVITY_STOP_TIME,     
	ACT_STOP_TIME_ZONE,     
	ACTIVITY_REL_DEPTH,     
	ACTIVITY_DEPTH,         
	ACTIVITY_DEPTH_UNIT,    
	ACTIVITY_UPPER_DEPTH,   
	ACTIVITY_LOWER_DEPTH,  
	UPR_LWR_DEPTH_UNIT,
	tsrfldpr_is_number,
	tsrgrcfg_is_number,
	TSRFLDGR_IS_NUMBER,
      FK_SUBJECT_TAXON,
	ACT_BLOB_TITLE
)
SELECT
      seq_FA_BIOLOGICAL_RESULT.nextval,
      RSULT.SPECIES_NUMBER,
	RSULT.VALUE_MEASURE,		
	RSULT.VALUE_TEXT,		
	RSULT.SMPL_FRAC_TYPE_NM,	
	RSULT.VALUE_TYPE_NAME,		
	RSULT.STATISTIC_TYPE_NM,	
	RSULT.VALUE_STATUS,		
	RSULT.WT_BASIS_TYPE_NM,		
	RSULT.TEMP_BASIS_LVL_NM,	
	RSULT.DUR_BASIS_TYPE_NM,	
	RSULT.LAB_CERT_IND_CODE,	
	RSULT.LAB_BATCH_ID_CODE,
TO_DATE(DECODE (to_char(rsult.analysis_date,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ANALYSIS_DATE_TIME,
	RSULT.ANALYSIS_TIME_ZONE,	
	RSULT.REF_PT_FROM_NAME,	
	RSULT.REF_PT_TO_NAME,		
	RSULT.REPL_ANALYSIS_NUM,	
	RSULT.PRECISION_AMT_TEXT,	
	RSULT.CONF_LVL_PCT_MSR	,	
	RSULT.DILUTION_IND_CODE,	
	RSULT.RECOVERY_IND_CODE,	
	RSULT.CORRECTION_IND_CD,	
	RSULT.TSRRSULT_IS_NUMBER,    	
	RSULT.TSRRSULT_ORG_ID,
	V_ORG.ORGANIZATION_IS_NUMBER,	
	RSULT.TSRFDACT_IS_NUMBER,
	RSULT.TSRCHAR_IS_NUMBER,
	RSULT.TSRCHAR_ORG_ID,
	RSULT.TSRUOM_IS_NUMBER,
	RSULT.TSRUOM_ORG_ID,
	RSULT.TSRANLPR_IS_NUMBER,
	RSULT.TSRANLPR_ORG_ID,
	RSULT.TSRLSPP_IS_NUMBER,
	RSULT.TSRLSPP_ORG_ID,
	RSULT.TSRLAB_IS_NUMBER,
	RSULT.BIAS,
	RSULT.CONF_LVL_CORR_BIAS,
      RSULT.FNCTIONAL_FEED_GRP,
      RSULT.TAXON_POLLUTION,
      RSULT.TROPHIC_LEVEL,
      f_prmvl(RSULT.TSMPRMVL0IS_NUMBER,'ZZZZZZZZ'),  -- Habit
      f_prmvl(RSULT.TSMPRMVL1IS_NUMBER,'ZZZZZZZZ'),  -- Voltinism
      RSULT.TSMPRMVL_IS_NUMBER,
	TRIM(RSULT.BLOB_TITLE),
--activity elements
TO_DATE(DECODE (to_char(FDACT.START_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ACTIVITY_START_DATE_TIME,
	FDACT.START_TIME_ZONE,		
	FDACT.TSRSTVST_IS_NUMBER,
 	FDACT.ID_CODE,            
 	FDACT.REPLICATE_NUMBER,       
 	FDACT.MEDIUM_TYPE_NAME,	
	FDACT.TYPE_NAME,          
 	FDACT.CATEGORY_TYPE_NAME,      
 	FDACT.INTENT_TYPE_NAME,        
      rtrim(f_char_name(FDACT.TSRCHAR_IS_NUMBER,FDACT.TSRCHAR_ORG_ID)||' '||FDACT.SPECIES_NUMBER),     	
      f_biopt(FDACT.TSRBIOPT_IS_NUMBER,FDACT.TSRBIOPT_ORG_ID),
TO_DATE(DECODE (to_char(FDACT.STOP_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ACTIVITY_STOP_DATE_TIME,
	FDACT.STOP_TIME_ZONE,     
	FDACT.RELTV_DEPTH_NAME,     
	FDACT.DEPTH_TO_ACTIVITY,         
	FDACT.DEPTH_TO_ACT_UN_CD,    
	FDACT.UPPER_DEPTH_TO_ACT,   
	FDACT.LOWER_DEPTH_TO_ACT,  
	FDACT.DEPTH_MSR_UNT_CD,
	FDACT.tsrfldpr_is_number,
	FDACT.tsrgrcfg_is_number,
	FDACT.TSRFLDGR_IS_NUMBER,
      FDACT.TSRCHAR_IS_NUMBER,
	TRIM(FDACT.BLOB_TITLE)
FROM STORET1.TSRRSULT RSULT, 
     Storet1.TSRFDACT FDACT
WHERE RSULT.TSRFDACT_IS_NUMBER = FDACT.TSRFDACT_IS_NUMBER
   AND RSULT.TSRFDACT_ORG_ID = FDACT.TSRFDACT_ORG_ID
   AND RSULT.value_status ='F'
   AND fdact.medium_type_name = 'Biological'
   AND FDACT.TSRFDACT_ORG_ID = v_org.organization_id;
commit;

-- Multi-Taxon, Single Taxon Group Summary, Single Taxon Frequency
INSERT INTO FA_BIOLOGICAL_RESULT (pk_isn,
      SPECIES_NUMBER,
	RESULT_VALUE,
	RESULT_VALUE_TEXT,
	SAMPLE_FRACTION_TYPE,
	RESULT_VALUE_TYPE,
	STATISTIC_TYPE,
	RESULT_VALUE_STATUS,
	WEIGHT_BASIS_TYPE,
	TEMPERATURE_BASIS_LEVEL,
	DURATION_BASIS,
	LAB_CERTIFIED,
	LAB_BATCH_ID,
	ANALYSIS_DATE_TIME,
	--ANALYSIS_TIME,
	ANALYSIS_TIME_ZONE,
	DISTANCE_MEASURE_FROM,
	DISTANCE_MEASURE_TO,
	REPLICATE_ANALYSIS_COUNT,
	PRECISION,
	CONFIDENCE_LEVEL,
	DILUTION_INDICATOR,
	RECOVERY_INDICATOR,
	CORRECTION_INDICATOR,
	RESULT_IS_NUMBER,
	ORGANIZATION_ID,
	ORGANIZATION_IS_NUMBER,
	ACTIVITY_IS_NUMBER,
	FK_CHAR,
	TSRCHAR_ORG_ID,
	FK_UNIT_CONVERSION,
	TSRUOM_ORG_ID,
	TSRANLPR_IS_NUMBER,
	TSRANLPR_ORG_ID,
	TSRLSPP_IS_NUMBER,
	TSRLSPP_ORG_ID,
	TSRLAB_IS_NUMBER,
	BIAS,
	CONF_LVL_CORR_BIAS, 
      FEEDING_GROUP,
      POLLUTION_TOLERANCE,
      TROPHIC_LEVEL,
      HABIT,
      VOLTINISM,
      TSRBRG_IS_NUMBER,
      TSMPRMVL_IS_NUMBER,
	BLOB_TITLE,
--activity elements
	ACTIVITY_START_DATE_TIME,
	--ACTIVITY_START_TIME,
	ACT_START_TIME_ZONE,
	TSRSTVST_IS_NUMBER,
 	ACTIVITY_ID,            
 	REPLICATE_NUMBER,       
	ACTIVITY_MEDIUM,
 	ACTIVITY_TYPE,          
 	ACTIVITY_CATEGORY,      
 	ACTIVITY_INTENT,        
 	ACTIVITY_COMMUNITY,
	ACTIVITY_STOP_DATE_TIME,     
	--ACTIVITY_STOP_TIME,     
	ACT_STOP_TIME_ZONE,     
	ACTIVITY_REL_DEPTH,     
	ACTIVITY_DEPTH,         
	ACTIVITY_DEPTH_UNIT,    
	ACTIVITY_UPPER_DEPTH,   
	ACTIVITY_LOWER_DEPTH,  
	UPR_LWR_DEPTH_UNIT,
	tsrfldpr_is_number,
	tsrgrcfg_is_number,
	TSRFLDGR_IS_NUMBER,
	ACT_BLOB_TITLE
--	TSRMATRX_IS_NUMBER
)
SELECT
      seq_FA_BIOLOGICAL_RESULT.nextval,
      RSULT.SPECIES_NUMBER,
	RSULT.VALUE_MEASURE,		
	RSULT.VALUE_TEXT,		
	RSULT.SMPL_FRAC_TYPE_NM,	
	RSULT.VALUE_TYPE_NAME,		
	RSULT.STATISTIC_TYPE_NM,	
	RSULT.VALUE_STATUS,		
	RSULT.WT_BASIS_TYPE_NM,		
	RSULT.TEMP_BASIS_LVL_NM,	
	RSULT.DUR_BASIS_TYPE_NM,	
	RSULT.LAB_CERT_IND_CODE,	
	RSULT.LAB_BATCH_ID_CODE,
TO_DATE(DECODE (to_char(rsult.analysis_date,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ANALYSIS_DATE_TIME,
	RSULT.ANALYSIS_TIME_ZONE,	
	RSULT.REF_PT_FROM_NAME,	
	RSULT.REF_PT_TO_NAME,		
	RSULT.REPL_ANALYSIS_NUM,	
	RSULT.PRECISION_AMT_TEXT,	
	RSULT.CONF_LVL_PCT_MSR	,	
	RSULT.DILUTION_IND_CODE,	
	RSULT.RECOVERY_IND_CODE,	
	RSULT.CORRECTION_IND_CD,	
	RSULT.TSRRSULT_IS_NUMBER,    	
	RSULT.TSRRSULT_ORG_ID,	
	V_ORG.ORGANIZATION_IS_NUMBER,
	FDACT.TSRFDACT_IS_NUMBER,
	RSULT.TSRCHAR_IS_NUMBER,
	RSULT.TSRCHAR_ORG_ID,
	RSULT.TSRUOM_IS_NUMBER,
	RSULT.TSRUOM_ORG_ID,
	RSULT.TSRANLPR_IS_NUMBER,
	RSULT.TSRANLPR_ORG_ID,
	RSULT.TSRLSPP_IS_NUMBER,
	RSULT.TSRLSPP_ORG_ID,
	RSULT.TSRLAB_IS_NUMBER,
	RSULT.BIAS,
	RSULT.CONF_LVL_CORR_BIAS,
      RSULT.FNCTIONAL_FEED_GRP,
      RSULT.TAXON_POLLUTION,
      RSULT.TROPHIC_LEVEL,
      f_prmvl(RSULT.TSMPRMVL0IS_NUMBER,'ZZZZZZZZ'),  -- Habit
      f_prmvl(RSULT.TSMPRMVL1IS_NUMBER,'ZZZZZZZZ'),  -- Voltinism
      RSULT.TSRBRG_IS_NUMBER,
      RSULT.TSMPRMVL_IS_NUMBER,
	TRIM(RSULT.BLOB_TITLE),
--activity elements
TO_DATE(DECODE (to_char(FDACT.START_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ACTIVITY_START_DATE_TIME,
	FDACT.START_TIME_ZONE,		
	FDACT.TSRSTVST_IS_NUMBER,
 	FDACT.ID_CODE,            
 	FDACT.REPLICATE_NUMBER,       
 	FDACT.MEDIUM_TYPE_NAME,	
	FDACT.TYPE_NAME,          
 	FDACT.CATEGORY_TYPE_NAME,      
 	FDACT.INTENT_TYPE_NAME,        
 	FDACT.COMMUNITY_NAME,
TO_DATE(DECODE (to_char(FDACT.STOP_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ACTIVITY_STOP_DATE_TIME,
	FDACT.STOP_TIME_ZONE,     
	FDACT.RELTV_DEPTH_NAME,     
	FDACT.DEPTH_TO_ACTIVITY,         
	FDACT.DEPTH_TO_ACT_UN_CD,    
	FDACT.UPPER_DEPTH_TO_ACT,   
	FDACT.LOWER_DEPTH_TO_ACT,  
	FDACT.DEPTH_MSR_UNT_CD,
	FDACT.tsrfldpr_is_number,
	FDACT.tsrgrcfg_is_number,
	FDACT.TSRFLDGR_IS_NUMBER,
	TRIM(FDACT.BLOB_TITLE)
FROM STORET1.TSRRSULT RSULT, 
     Storet1.TSRFDACT FDACT,
     STORET1.TSRBRG BRG
WHERE RSULT.TSRBRG_IS_NUMBER=BRG.TSRBRG_IS_NUMBER
   AND RSULT.TSRBRG_ORG_ID = BRG.TSRBRG_ORG_ID
   AND BRG.TSRFDACT_IS_NUMBER=FDACT.TSRFDACT_IS_NUMBER
   AND BRG.TSRFDACT_ORG_ID=FDACT.TSRFDACT_ORG_ID
   AND RSULT.value_status ='F'
   AND fdact.medium_type_name = 'Biological'
   AND FDACT.TSRFDACT_ORG_ID = v_org.organization_id;
commit;

-- Single Taxon Individual results
INSERT INTO FA_BIOLOGICAL_RESULT (pk_isn,
      SPECIES_NUMBER,
	RESULT_VALUE,
	RESULT_VALUE_TEXT,
	SAMPLE_FRACTION_TYPE,
	RESULT_VALUE_TYPE,
	STATISTIC_TYPE,
	RESULT_VALUE_STATUS,
	WEIGHT_BASIS_TYPE,
	TEMPERATURE_BASIS_LEVEL,
	DURATION_BASIS,
	LAB_CERTIFIED,
	LAB_BATCH_ID,
	ANALYSIS_DATE_TIME,
	--ANALYSIS_TIME,
	ANALYSIS_TIME_ZONE,
	DISTANCE_MEASURE_FROM,
	DISTANCE_MEASURE_TO,
	REPLICATE_ANALYSIS_COUNT,
	PRECISION,
	CONFIDENCE_LEVEL,
	DILUTION_INDICATOR,
	RECOVERY_INDICATOR,
	CORRECTION_INDICATOR,
	RESULT_IS_NUMBER,
	ORGANIZATION_ID,
	ORGANIZATION_IS_NUMBER,
	ACTIVITY_IS_NUMBER,
	FK_CHAR,
	TSRCHAR_ORG_ID,
	FK_UNIT_CONVERSION,
	TSRUOM_ORG_ID,
	TSRANLPR_IS_NUMBER,
	TSRANLPR_ORG_ID,
	TSRLSPP_IS_NUMBER,
	TSRLSPP_ORG_ID,
	TSRLAB_IS_NUMBER,
      TSRBRG_IS_NUMBER,
      TSRBRGI_IS_NUMBER,
      TSMPRMVL_IS_NUMBER,
	BLOB_TITLE,
--activity elements
	ACTIVITY_START_DATE_TIME,
	ACT_START_TIME_ZONE,
	TSRSTVST_IS_NUMBER,
 	ACTIVITY_ID,            
 	REPLICATE_NUMBER,       
	ACTIVITY_MEDIUM,
 	ACTIVITY_TYPE,          
 	ACTIVITY_CATEGORY,      
 	ACTIVITY_INTENT,        
 	ACTIVITY_COMMUNITY,
	ACTIVITY_STOP_DATE_TIME,     
	--ACTIVITY_STOP_TIME,     
	ACT_STOP_TIME_ZONE,     
	ACTIVITY_REL_DEPTH,     
	ACTIVITY_DEPTH,         
	ACTIVITY_DEPTH_UNIT,    
	ACTIVITY_UPPER_DEPTH,   
	ACTIVITY_LOWER_DEPTH,  
	UPR_LWR_DEPTH_UNIT,
	tsrfldpr_is_number,
	tsrgrcfg_is_number,
	TSRFLDGR_IS_NUMBER,
	ACT_BLOB_TITLE,
--single taxon individual elements
      NUMBER_IN_GROUP,
      INDIVIDUAL_NUMBER
)
SELECT
      seq_FA_BIOLOGICAL_RESULT.nextval,
      RSULT.SPECIES_NUMBER,
	RSULT.VALUE_MEASURE,		
	RSULT.VALUE_TEXT,		
	RSULT.SMPL_FRAC_TYPE_NM,	
	RSULT.VALUE_TYPE_NAME,		
	RSULT.STATISTIC_TYPE_NM,	
	RSULT.VALUE_STATUS,		
	RSULT.WT_BASIS_TYPE_NM,		
	RSULT.TEMP_BASIS_LVL_NM,	
	RSULT.DUR_BASIS_TYPE_NM,	
	RSULT.LAB_CERT_IND_CODE,	
	RSULT.LAB_BATCH_ID_CODE,
TO_DATE(DECODE (to_char(rsult.analysis_date,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(rsult.analysis_date,'DD-MON-YYYY')||'-'||to_char(rsult.analysis_time,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ANALYSIS_DATE_TIME,
	RSULT.ANALYSIS_TIME_ZONE,	
	RSULT.REF_PT_FROM_NAME,	
	RSULT.REF_PT_TO_NAME,		
	RSULT.REPL_ANALYSIS_NUM,	
	RSULT.PRECISION_AMT_TEXT,	
	RSULT.CONF_LVL_PCT_MSR	,	
	RSULT.DILUTION_IND_CODE,	
	RSULT.RECOVERY_IND_CODE,	
	RSULT.CORRECTION_IND_CD,	
	RSULT.TSRRSULT_IS_NUMBER,    	
	RSULT.TSRRSULT_ORG_ID,	
	V_ORG.ORGANIZATION_IS_NUMBER,
	FDACT.TSRFDACT_IS_NUMBER,
	RSULT.TSRCHAR_IS_NUMBER,
	RSULT.TSRCHAR_ORG_ID,
	RSULT.TSRUOM_IS_NUMBER,
	RSULT.TSRUOM_ORG_ID,
	RSULT.TSRANLPR_IS_NUMBER,
	RSULT.TSRANLPR_ORG_ID,
	RSULT.TSRLSPP_IS_NUMBER,
	RSULT.TSRLSPP_ORG_ID,
	RSULT.TSRLAB_IS_NUMBER,
      RSULT.TSRBRG_IS_NUMBER,
      RSULT.TSRBRGI_IS_NUMBER,
      RSULT.TSMPRMVL_IS_NUMBER,
	TRIM(RSULT.BLOB_TITLE),
--activity elements
TO_DATE(DECODE (to_char(FDACT.START_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.START_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.START_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ACTIVITY_START_DATE_TIME,
	FDACT.START_TIME_ZONE,		
	FDACT.TSRSTVST_IS_NUMBER,
 	FDACT.ID_CODE,            
 	FDACT.REPLICATE_NUMBER,       
 	FDACT.MEDIUM_TYPE_NAME,	
	FDACT.TYPE_NAME,          
 	FDACT.CATEGORY_TYPE_NAME,      
 	FDACT.INTENT_TYPE_NAME,        
 	FDACT.COMMUNITY_NAME,
TO_DATE(DECODE (to_char(FDACT.STOP_DATE,'DD-MON-YYYY'), 	NULL, NULL,
							'01-JAN-0001', NULL,
		to_char(FDACT.STOP_DATE,'DD-MON-YYYY')||'-'||to_char(FDACT.STOP_TIME,'HH24:MI:SS')),'DD-MON-YYYY-HH24:MI:SS') ACTIVITY_STOP_DATE_TIME,
	FDACT.STOP_TIME_ZONE,     
	FDACT.RELTV_DEPTH_NAME,     
	FDACT.DEPTH_TO_ACTIVITY,         
	FDACT.DEPTH_TO_ACT_UN_CD,    
	FDACT.UPPER_DEPTH_TO_ACT,   
	FDACT.LOWER_DEPTH_TO_ACT,  
	FDACT.DEPTH_MSR_UNT_CD,
	FDACT.tsrfldpr_is_number,
	FDACT.tsrgrcfg_is_number,
	FDACT.TSRFLDGR_IS_NUMBER,
	TRIM(FDACT.BLOB_TITLE),
--single taxon individual elements
      BRG.SUMMARY_GRP_COUNT,
      BRGI.INDIVIDUAL_NUMBER
FROM STORET1.TSRRSULT RSULT, 
     Storet1.TSRFDACT FDACT,
     STORET1.TSRBRG BRG,
     STORET1.TSRBRGI BRGI
WHERE RSULT.TSRBRGI_IS_NUMBER=BRGI.TSRBRGI_IS_NUMBER
   AND RSULT.TSRBRGI_ORG_ID=BRGI.TSRBRGI_ORG_ID 
   AND BRGI.TSRBRG_IS_NUMBER=BRG.TSRBRG_IS_NUMBER
   AND BRGI.TSRBRG_ORG_ID=BRG.TSRBRG_ORG_ID
   AND BRG.TSRFDACT_IS_NUMBER=FDACT.TSRFDACT_IS_NUMBER
   AND BRG.TSRFDACT_ORG_ID=FDACT.TSRFDACT_ORG_ID
   AND RSULT.value_status ='F'
   AND fdact.medium_type_name = 'Biological'
   AND FDACT.TSRFDACT_ORG_ID = v_org.organization_id;
commit;

end loop;
commit;
end;
/
commit;
 
alter table FA_BIOLOGICAL_RESULT
add constraint pk_BIOLOGICAL_Result primary key (pk_isn)
using index
tablespace storetindx
storage(initial 2m next 1m);
--storage(initial 10m next 5m);
 
spool off;